<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/


class CTeamWidgetMembersWCarousel extends CWidget {

	/**
	* description
	*
	* @var type
	*
	* @access type
	*/
	var $meta = array(
		"type"	=> "1",
		"name"	=> "Members w/ Carousel",
	);

	/**
	* description
	
	* @param
	*
	* @return
	*
	* @access
	*/
	function Render($widget) {

		if ($widget["settings"]["set_show"] == "1") {
			$order = "rand()";
		} else {
			$order = "item_order ASC";
		}

		if (($widget["settings"]["set_show"] == "2") && $widget["settings"]["set_manual"]) {
			$cond = " AND i.item_id IN ({$widget['settings']['set_manual']} )";
			$widget["settings"]["set_items"] = 9999;
		} else {		
			if ($widget["settings"]["set_cat"]) {
				$tmp = explode("," , $widget["settings"]["set_cat"]);
				foreach ($tmp as $k => $v) {
					if ($v) {
						$_cond[] = "find_in_set($v , item_cat) ";
					}				
				}

				if (is_array($_cond)) {
					$cond = " AND ( " . implode(" OR "  , $_cond ) . ") ";
				}							
			}
		}


		$items = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['plugin:team_items']} as i , 
				{$this->tables['plugin:team_items_lang']} as l 
			WHERE
				i.item_id = l.item_id and 
				i.module_id = {$widget[mod_id]} AND 
				l.lang_id = {$widget[lang_id]} {$cond}
			ORDER BY 
				{$order}
			LIMIT {$widget[settings][set_items]}
			"
		);	


		if (is_array($items)) {

			if ($widget["settings"]["set_show"] == "2") {
				$items = SortByKeys($items , "item_id" , $widget["settings"]["set_manual"]);
			}


			global $base;

			$elements = explode("," , $widget["settings"]["set_elements"]);

			//some elements must be processed before the brief
			foreach ($items as $key => $val) {
				$items[$key]["_title"] = $items[$key]["_description"] = "";

				if (in_array("title" , $elements) && $val["item_brief_title"]) {
					$items[$key]["_title"] = $this->tpl->blockReplace("BriefTitle" , $val);
				} else {
					$items[$key]["item_brief_title"] = "";
				}

				if (in_array("description" , $elements) && $val["item_brief"]) {
					$val["item_brief"] = nl2br($val["item_brief"]);
					$items[$key]["_description"] = $this->tpl->blockReplace("Description" , $val);
				} else {
					$items[$key]["item_brief"] = "";
				}

				if (!in_array("link" , $elements)) {
					$items[$key]["item_link_type"] = "";
				}

				if (!in_array("description" , $elements) && !in_array("title" , $elements) && !in_array("link" , $elements)) {
					$items[$key]["item_brief"] = $items[$key]["item_brief_title"] = $items[$key]["item_link_type"] = "";
				}
							
			}
			
			


			$items = $this->module->ProcessItems(
				$items , 
				array(
					"set_items_size" => $widget["settings"]["set_size"]
				) , 
				$this->tpl
			);


			foreach ($items as $key => $val) {

				$items[$key]["_social"] = $items[$key]["_name"] = "";

				if (in_array("social" , $elements)) {
					$items[$key]["_social"] = $val["social"];
				}

				if (in_array("name" , $elements)) {
					$items[$key]["_name"] = $this->tpl->blockreplace("Name" , $val);
				}
				
			}

			

			return $this->tpl->blockReplace(
				"Main" , 
				array(
					"items"	=> $base->html->table(
						$this->tpl , 
						"" , 
						$items
					),
					"class"	=> $this->tpl->blockreplace($widget["settings"]["set_carousel"] ? "Carousel" :"List"),
				),
				$widget,
				$widget["settings"],
				$widget["mod_settings"]
			);
		}

	}
			

}


?>